/*   This program registers all of the primitive XDR filters with
 * an appropriate echo and return function.  The purpose of each echo
 * function is to simply return the argument passed to it.
 * The purpose of each return function is to ignore all input sent
 * during the call and return an argument appropriate to its output filter.
 */


#define echo_prog_num    0x20118651
#define return_prog_num  0x20118652
#define ver_num 1

/*************************************/
/***     Function declarations     ***/
/*************************************/
bool_t xdr_string_256();     /* xdr_string with maxsize hardcoded to 256 */
bool_t xdr_opaque_8();       /* xdr_opaque with cnt hardcoded to 8 */
bool_t xdr_opaque_9();       /* xdr_opaque with cnt hardcoded to 9 */
bool_t xdr_opaque_10();      /* xdr_opaque with cnt hardcoded to 10 */
bool_t xdr_opaque_11();      /* xdr_opaque with cnt hardcoded to 11 */    
bool_t xdr_array_int();
bool_t xdr_array_float();

/****************************************/
/***        Test data arrays          ***/
/****************************************/

enum_t  enum_data[]       = { 0x7fffffff, 0, -2147483648 };
int     int_data[]        = { 0x7fffffff, 0, -2147483648 };
u_int   u_int_data[]      = { 0xffffffff, 0 };
long    long_data[]       = { 0x7fffffff, 0, -2147483648 };
u_long  u_long_data[]     = { 0xffffffff, 0 };
float   float_data[]      = { 9.625, 9.8657856, 0.0, -1234.625 };
double  double_data[]     = { 9.625, 9.8657856, 0.0, -1234.625 };
bool_t  bool_data[]       = { 1, 0 };
short   short_data[]      = { 0x7fff, 0 ,-32768 };
u_short u_short_data[]    = { 0xffff, 0 };
char *  string_data[]     = { "This is a string.", "!@#$%^&*()0987654321", "????????????????????????????????????????" };
char *  wrapstring_data[] = { "This is a string.", "!@#$%^&*()0987654321", "????????????????????????????????????????" };
char *  opaque_8_data[]   = { "eighteig", "12345678", "!@#$%^&*" };
char *  opaque_9_data[]   = { "nineninen", "123456789", "!@#$%^&*(" };
char *  opaque_10_data[]  = { "tententent", "1234567890", "!@#$%^&*()" };
char *  opaque_11_data[]  = { "eleveneleve", "12345678901", "!@#$%^&*()!" };












